<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Contatore {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="") {
            $this->db   = $db;
            $this->id   = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
        }

        function crea() {
            $query    = "INSERT INTO geec_contatori VALUES(NULL,'$this->nome','$this->spazioOccupato')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_contatori SET nome='$this->nome', spazioOccupato='$this->spazioOccupato' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_contatori",$this->id);
            
            $queryEliminaElementiLista = "DELETE FROM geec_elementiContatore WHERE idContatore = $this->id";
            $this->db->eseguiQueryScrittura($queryEliminaElementiLista);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 42
            eliminaOccorrenzeComponente($this->db,$this->id,42);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_contatori VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_elementiContatore WHERE idContatore='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_elementiContatore` (`id`, `idContatore`, `posizione`, `etichetta`, `colore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_elementiContatore WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_elementiContatore SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_elementiContatore SET etichetta = CONCAT('$prefisso', ' ', etichetta) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiLista   = $this->db->leggiSingolaRiga("geec_contatori",$this->id);
            $this->nome = $datiLista["nome"];
            $this->spazioOccupato = $datiLista["spazioOccupato"];
        }
        
        function creaElemento($etichetta,$numero,$icona) {
            $queryPosizione = "SELECT * FROM geec_elementiContatore WHERE idContatore=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_elementiContatore` (`id`, `idContatore`, `posizione`, `etichetta`, `colore`, `icona`, `dimensioneIcona`, `valore`) "
                    . "VALUES (NULL, '$this->id', '$posizione', '$etichetta', '','$icona','','$numero')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            
            $query = "SELECT * FROM geec_elementiContatore WHERE idContatore = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="d-flex">
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left w-100">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["etichetta"] ?></strong></a></em></p>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <form class="d-inline-flex mr-sm-1">
                            <div class="input-group input-group-sm d-flex align-items-center">
                                <small class="text-muted mr-2">Pos.</small>
                                <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $elemento["etichetta"]; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$etichetta,$valore,$icona,$dimensioneIcona,$colore) {
            $query = "UPDATE geec_elementiContatore SET etichetta='$etichetta', valore='$valore', icona='$icona', dimensioneIcona='$dimensioneIcona', colore='$colore' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_elementiContatore` SET  percorsoImmagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_elementiContatore WHERE idContatore=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_elementiContatore SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_elementiContatore SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_elementiContatore",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getIcona() {
            return $this->icona;
        }

        public function getTipoVisualizzazione() {
            return $this->tipoVisualizzazione;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setIcona($icona) {
            $this->icona = $icona;
        }

        public function setTipoVisualizzazione($tipoVisualizzazione) {
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }
        
    }